/**
* \file: AditCoreSurrogateChannel.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample channel implementation for connection setup callbacks
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#include <adit_logging.h>
#include <bdcl/AditCoreSurrogate.h>
#include "AditCoreSurrogateChannel.h"
#include "BdclSmoketest.h"
#include "Server.h"

LOG_IMPORT_CONTEXT(tbdcl)
#define TIME_OUT 5
namespace adit { namespace bdcl {

AditCoreSurrogateChannel::AditCoreSurrogateChannel(CoreCallbackDealer* inCallbackDealer)
{
    mCounter = 0;
    mCoreSurrogate = new AditCoreSurrogate(this, inCallbackDealer);

}

AditCoreSurrogateChannel::~AditCoreSurrogateChannel()
{
    delete mCoreSurrogate;
}

void AditCoreSurrogateChannel::onProtocolVersionMatchStatus(bool inMatchStatus)
{
    LOGD_DEBUG((tbdcl, "%s initiated", __PRETTY_FUNCTION__));
}

void AditCoreSurrogateChannel::onAuthenticationResponse(bool inResponse)
{
    LOGD_DEBUG((tbdcl, "%s initiated: %d", __PRETTY_FUNCTION__, inResponse));
}

void AditCoreSurrogateChannel::onError(bdclErrorCodes inErrorCode)
{
    LOG_WARN((tbdcl, "%s initiated with error code = %d", __FUNCTION__, inErrorCode));
    if( inErrorCode == AOAP_READ_TIMEOUT_ERROR || inErrorCode == AOAP_WRITE_TIMEOUT_ERROR)
    {
        if ( mCounter == 0){
            LOGD_DEBUG((tbdcl, "Started Counter to close the session"));
            AutoSmoketest::instance().setTestError(PHONENOTRESPONDING);
        }
        mCounter++;
        if (mCounter >= TIME_OUT){
            if (inErrorCode == AOAP_READ_TIMEOUT_ERROR){
                createEvent("AOAP read timeout");
            }else if(inErrorCode == AOAP_WRITE_TIMEOUT_ERROR){
                createEvent("AOAP write timeout");
            }
        }
    }
    else if( inErrorCode == AOAP_NO_ERROR )
    {
        LOGD_DEBUG((tbdcl, "Resetting the counter as phone start responding"));
        mCounter = 0;
    }
}

void AditCoreSurrogateChannel::createEvent(std::string inString)
{
    LOG_INFO((tbdcl, "%s Closing the session after timer expires %d sec", __PRETTY_FUNCTION__, TIME_OUT));
    std::shared_ptr<EventItem> event(new EventItem(nullptr, EventType::AOAPREADTIMEOUT,inString,""));
    Server::instance().queueEvent(event);
}

} } /* namespace adit { namespace bdcl { */
